package cn.gtmap.hlw.core.exception;

import lombok.Data;

/**
 * @version V1.0
 * @Description 自定义异常处理类
 * @Author admin
 * @Date 2022/12/29 17:11
 **/
@Data
public class TokenException extends RuntimeException{
    /**
     * 错误代码:返回给前端
     * 客户端需要根据服务端的错误代码进行处理
     */
    private IError iError;

    /**
     * 需要打印日志的：失败信息描述
     */
    private String message;

    public TokenException(String code , String message) {
        IError iError = new IError() {
            @Override
            public String getCode() {
                return code;
            }

            @Override
            public String getMsg() {
                return message;
            }
        };
        this.iError = iError;
        this.message = message;
    }

    public TokenException(IError iError) {
        super(iError.getMsg());
        this.iError = iError;
        this.message = iError.getMsg();
    }

    public TokenException(IError iError, Throwable cause) {
        super(iError.getMsg(), cause);
        this.iError = iError;
    }


    public TokenException(IError iError, String message) {
        super(message);
        this.iError = iError;
        this.message = message;
    }

    public TokenException(IError iError, String message, Throwable cause) {
        super(message, cause);
        this.iError = iError;
        this.message = message;
    }
}
