package cn.gtmap.hlw.core.enums.qlr;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 持证方式类型
 *
 * @author admin
 * @Date 2023-06-25
 * @Version V1.0
 */
@Getter
@AllArgsConstructor
public enum CzfsEnum {
    /**
     * 持证方式-共同持证
     */
    CZFS_GTCZ ("1", "共同持证"),
    /**
     * 持证方式-分别持证
     */
    CZFS_FBCZ ("2", "分别持证");


    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (CzfsEnum xq : CzfsEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}

