/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.base.ApiEncryptBody;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.encryption.sm4.Sm4Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiSecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(ApiSecurityUtils.class);

    public static String decrypt(String sm4KeyBySm2, String decryptStr) {
        String sm4Key = Sm2lib.decode(sm4KeyBySm2);
        return Sm4Util.decryptEcb(sm4Key, decryptStr);
    }

    public static ApiEncryptBody encrypt(String encryptStr, String frontPublicKey) {
        String sm4Key = null;
        try {
            sm4Key = Sm4Util.generateKey();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String data = Sm4Util.encryptEcbByHutool(sm4Key, encryptStr);
        ApiEncryptBody apiEncryptRes = new ApiEncryptBody();
        apiEncryptRes.setParamid(Sm2lib.encode(sm4Key, frontPublicKey));
        apiEncryptRes.setData(data);
        apiEncryptRes.setFrontKey(frontPublicKey);
        return apiEncryptRes;
    }

    public static void main(String[] args) throws Exception {
        String pubKey = "c2f1831616943efe504bde6b45d59eea953f04d31ecebd4c59dffd6733c7a066c7a9c14cb2c54564187891f72753fea7f56d07b19d52e9076263564def41b8e7";
        String dataEncrypt = "fb4cfa69dfa0e3175fdb7ae3d15a670a68693d7b78d02273ab708860da8152a5a1dd8775f2b0dd162ee8dacf9626dec299bdecb2970748d64cf7c6cf05b81309";
        String paramid = "04186c67b511096b948b7a800e3c3b71bff92e537c19d35b2b946237a7fff3687de6b6521ef64ea0f8f8c0ad9d4980cc8f12640f1aae31bba34ae5d2a28474aa04eb82afb6feaa79dc6fdd4c5a276466a0eae512f62546f5ee91040c030f5437a13c7674e8814812a33ccecd7aebbab71d015e0239d56fcaba0b0e61d0e134d90038bda7691344fe79cda1cb50";
        String qdData = ApiSecurityUtils.decrypt(paramid, dataEncrypt);
        System.out.println(qdData);
    }
}

