package cn.gtmap.hlw.core.util.pdf;

import cn.gtmap.hlw.core.util.date.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.Date;
import java.util.regex.Matcher;

/**
 * @author <a href="mailto:zhaobiqiang@gtmap.cn">zhaobiqiang</a>
 * @version 1.0, 2023/3/16
 * @description
 */
public class FilePathUtil {


    private static final Logger log = LoggerFactory.getLogger(FilePathUtil.class);

    /**
     * 在指定的文件路径中添加当前日期的目录
     *
     * @param filePath   文件路径字符串
     * @param folderName 需要识别的目录名
     * @return 完整的文件路径字符串
     */
    public static String addDateDirectoriesToFilePath(String filePath, String folderName) {
        String finalPath = filePath;
        //文件路径不存在对应目录或执行报错时返回原文件路径
        if (StringUtils.indexOf(filePath, folderName) > -1) {
            try {
                String formattedDate = DateUtils.dateToStr(new Date(), DateUtils.DATE_FORMAT_FILE);
                String[] pathSegments = filePath.split(Matcher.quoteReplacement(File.separator));
                StringBuilder sb = new StringBuilder();
                if (pathSegments.length == 1) {
                    sb.append(pathSegments[0]).append(File.separator).append(formattedDate);
                } else {
                    for (int i = 0; i < pathSegments.length; i++) {
                        if (i == 0) {
                            sb.append(pathSegments[i]);
                        } else {
                            if (pathSegments[i - 1].equals(folderName)) {
                                sb.append(File.separator).append(formattedDate);
                            }
                            sb.append(File.separator).append(pathSegments[i]);
                        }
                    }
                }
                finalPath = sb.toString();
            } catch (Exception e) {
                log.error("文件路径:" + filePath + ",追加日期目录名:" + folderName + ",追加失败,返回原路径", e);
            }
        }
        return finalPath;
    }

    /**
     * @Description 获取tomcat路径
     * @Author admin
     * @Date 2023/3/28 15:57
     **/
    public static String getPropFolderPath() {
        //获取tomcat的路径
        String path = System.getProperty("catalina.home");
        if (StringUtils.isEmpty(path)) {
            path = FilePathUtil.class.getResource("/").getPath();
            path = new File(path).getParent() + File.separator;
        } else {
            path = path + File.separator;
        }
        return path;
    }
}
