package cn.gtmap.hlw.core.util.http;

import cn.gtmap.hlw.core.constant.Constants;
import cn.gtmap.hlw.core.dto.third.dzzz.DzzzShieldSyncAppDTO;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.util.encryption.Md5Util;
import com.alibaba.fastjson.JSONObject;
import com.iflytek.fsp.shield.java.sdk.http.BaseApp;
import com.iflytek.fsp.shield.java.sdk.model.ApiResponse;
import epoint.frame.encrypt.sm2.SM2Util;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.nio.charset.StandardCharsets;
import java.util.UUID;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2023/11/30
 * @description 电子证照工具类
 */
@Slf4j
public class DzzzUtils extends BaseApp {

    public static String sendRequest(DzzzShieldSyncAppDTO appDTO, String method, String privateKey, String enc) {
        // 通过Api网关请求
        String res = "";
        ShieldSyncApp test = new ShieldSyncApp(appDTO);
        String timestamp = String.valueOf(System.currentTimeMillis());
        String nonce = UUID.randomUUID().toString();
        String unSign = test.getAppId() + method + timestamp + nonce;
        log.info("timestamp: {}", timestamp);
        log.info("nonce: {}", nonce);
        log.info("unSign: {}", unSign);
        log.info("appId:{}", test.getAppId());
        String sign = Md5Util.encode(unSign);
        log.info("MD5加密后的sign:{}", sign);
        try {
            byte[] bytes = enc.getBytes(StandardCharsets.UTF_8);
            ApiResponse response = test.ZZK_OPENAPI_GATEWAY(bytes, method, timestamp,
                    nonce, sign);
            res = new String(response.getBody(), StandardCharsets.UTF_8);
            log.info("解密前结果:{}", res);

            JSONObject resObj = JSONObject.parseObject(res);
            if (resObj.getBooleanValue(Constants.SUCCESS)) {
                String data = resObj.getString("data");
                if (data != null && !StringUtils.equals(data, Constants.NULL)) {
                    // 解密util 初始化
                    SM2Util sm2DecUtil = new SM2Util(null, privateKey);
                    // 解密
                    res = sm2DecUtil.decrypt(data);
                    log.info("解密结果:{}", res);
                    return res;
                }
            } else {
                throw new BizException(ErrorEnum.FAIL.getCode(), resObj.getString("errorMessage"));
            }
        } catch (Exception e) {
            log.error("DzzzUtils.sendRequest", e);
            throw new BizException(ErrorEnum.FAIL.getCode(), e.getMessage());
        }
        return "";
    }

    public static String encrypt(String publicKey, String str) {
        // 加密util 初始化
        SM2Util sm2EncUtil = new SM2Util(publicKey, null);
        log.info("原始内容：" + str);
        // 加密
        String enc;
        try {
            enc = sm2EncUtil.encrypt(str);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.info("加密结果：" + enc);
        return enc;
    }

}
