package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.WctJyWxjj;

import java.util.List;

/**
 * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
 * @version 1.0, 2024/11/29
 * @description 维修基金服务
 */
public interface WctJyWxjjRepository {

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 根据收费收税信息id获取维修基金信息
     */
    List<WctJyWxjj> listBySfssxxid(String sfssxxid);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 保存维修基金信息
     */
    void save(WctJyWxjj wctJyWxjj);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 删除维修基金信息
     */
    void delete(String wxjjxxid);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 根据受理编号获取维修基金信息
     */
    List<WctJyWxjj> listBySlbh(String slbh);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 更新维修基金信息
     */
    void updata(WctJyWxjj wctJyWxjj);
}
