package cn.gtmap.hlw.core.repository;


import cn.gtmap.hlw.core.model.WctJyTkxx;
import cn.gtmap.hlw.core.model.query.wct.WctJyTkxxQuery;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.List;
import java.util.Map;

/**
 * (WctJyTkxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface WctJyTkxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    WctJyTkxx get(String id);

    /**
     * 新增数据
     *
     * @param WctJyTkxx 实例对象
     * @return 影响行数
     */
    void save(WctJyTkxx WctJyTkxx);

    /**
     * 修改数据
     *
     * @param WctJyTkxx 实例对象
     * @return 影响行数
     */
    void update(WctJyTkxx WctJyTkxx);

    /**
     * 批量新增数据
     *
     * @param tkxxList 实例对象
     * @return 影响行数
     */
    void saveBatch(List<WctJyTkxx> tkxxList);

    /**
     * 查询（根据 columnMap 条件）
     *
     * @param map 实例对象
     * @return 影响行数
     */
    List<WctJyTkxx> getListByMap(Map<String, Object> map);


    /**
     * 根据受理编号查询订单信息
     * @param slbh
     * @return:List<WctJyTkxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<WctJyTkxx> listBySlbh(String slbh);
    /**
     * 根据订单编号查询
     * @param ddbh
     * @return:cn.gtmap.hlw.domain.wct.model.WctJyTkxx
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    WctJyTkxx getByDdbh(String ddbh);
    /**
     * 保存或者更新
     * @param tkxx
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void saveOrUpdate(WctJyTkxx tkxx);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 分页查询退款信息
     */
    IPage<WctJyTkxx> getTkxxPage(WctJyTkxxQuery wctJyTkxxQuery);
}

