package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyUserOrgRel;

import java.util.List;

/**
 * (GxYyUserOrgRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface GxYyUserOrgRelRepository {

    List<GxYyUserOrgRel> getByUserIdList(List<String> userIdList);

    /**
     * 通过ID查询单条数据
     *
     * @param userOrgRelId 主键
     * @return 实例对象
     */
    GxYyUserOrgRel get(String userOrgRelId);

    /**
     * 新增数据
     *
     * @param gxYyUserOrgRel 实例对象
     * @return 影响行数
     */
    void save(GxYyUserOrgRel gxYyUserOrgRel);

    /**
     * 新增或更新数据
     *
     * @param gxYyUserOrgRel 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYyUserOrgRel gxYyUserOrgRel);

    /**
     * 修改数据
     *
     * @param gxYyUserOrgRel 实例对象
     * @return 影响行数
     */
    void update(GxYyUserOrgRel gxYyUserOrgRel);

    /**
     * 查询数据
     *
     * @param userId 用户id
     * @return 影响行数
     */
    GxYyUserOrgRel getUserOrgRelByUserId(String userId);

    /**
     * 获取数据
     *
     * @return 影响行数
     */
    List<GxYyUserOrgRel> getAll();

    /**
     * 删除数据
     *
     * @param userOrgRelId
     * @return 影响行数
     */
    int delete(String userOrgRelId);

    void deleteByUserId(String userId);

    /**
     * 根据orgid查询
     *
     * @param orgId
     * @return
     */
    List<GxYyUserOrgRel> getByOrgId(String orgId);

    /**
     * 根据orgid查询
     *
     * @param orgIdList
     * @return
     */
    List<GxYyUserOrgRel> getByOrgIdList(List<String> orgIdList);
    /**
     * 根据userid\orgid查询
     * @param userId
     * @param orgId
     * @return:cn.gtmap.hlw.core.model.GxYyUserOrgRel
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyUserOrgRel getUserOrgRelByUserIdAndOrgId(String userId, String orgId);
}

