package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxFsss;

import java.util.List;
import java.util.Map;

/**
 * 申请信息-附属设施信息(GxYySqxxFsss)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:44
 */
public interface GxYySqxxFsssRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYySqxxFsss get(String id);

    /**
     * 通过ID查询数据集合
     *
     * @param sqid 申请ID
     * @return 实例对象
     */
    List<GxYySqxxFsss> list(String sqid);

    /**
     * 新增数据
     *
     * @param gxYySqxxFsss 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxFsss gxYySqxxFsss);

    /**
     * 新增或更新数据
     *
     * @param gxYySqxxFsss 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYySqxxFsss gxYySqxxFsss);

    /**
     * 修改数据
     *
     * @param gxYySqxxFsss 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxFsss gxYySqxxFsss);

    /**
     * 批量新增或修改数据
     *
     * @param gxYySqxxFsssList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYySqxxFsss> gxYySqxxFsssList);

    /**
     * 根据申请ID删除数据
     *
     * @param sqid 申请ID
     * @return 影响行数
     */
    int deleteBySqid(String sqid);

    /**
     * 查询数据集合
     *
     * @param map
     * @return 实例对象
     */
    List<GxYySqxxFsss> getListByMap(Map map);

    /**
     * 通过sqidList查询单条数据
     *
     * @param sqidList 主键
     * @return 实例对象
     */
    List<GxYySqxxFsss> list(List<String> sqidList);

    /**
     * 根据sqidList删除数据
     *
     * @param sqidList 申请ID
     * @return 影响行数
     */
    int deleteBySqidList(List<String> sqidList);

    /**
     * 根据申请id和附属设施种类查询数据
     *
     * @param sqid 申请ID
     * @param fssszl 附属设施种类
     * @return 影响行数
     */
    GxYySqxxFsss getBySqidAndFssszl(String sqid, String fssszl);
}

