package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.BasePage;
import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.model.GxYyOrgWlxx;

import java.util.List;

/**
 * 部门物流信息(GxYyOrgWlxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface GxYyOrgWlxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyOrgWlxx get(String id);

    /**
     * 新增数据
     *
     * @param gxYyOrgWlxx 实例对象
     * @return 影响行数
     */
    void save(GxYyOrgWlxx gxYyOrgWlxx);

    /**
     * 修改数据
     *
     * @param gxYyOrgWlxx 实例对象
     * @return 影响行数
     */
    void update(GxYyOrgWlxx gxYyOrgWlxx);

    /**
     * 获取数据
     *
     * @return 影响行数
     */
    List<GxYyOrgWlxx> getAll();

    /**
     * 删除数据
     *
     * @param id
     * @return 影响行数
     */
    int delete(String id);

    /**
     * 分页查询
     *
     * @param id    id
     * @param orgId 公司id
     * @param page
     * @return 影响行数
     */
    PageInfo<GxYyOrgWlxx> queryPage(String id, String orgId, BasePage page);

}

