package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyMenuResourceRel;

import java.util.List;

/**
 * (GxYyMenuResourceRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 14:34:59
 */
public interface GxYyMenuResourceRelRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyMenuResourceRel get(String id);

    /**
     * 新增数据
     *
     * @param gxYyMenuResourceRel 实例对象
     * @return 影响行数
     */
    void save(GxYyMenuResourceRel gxYyMenuResourceRel);

    /**
     * 修改数据
     *
     * @param gxYyMenuResourceRel 实例对象
     * @return 影响行数
     */
    void update(GxYyMenuResourceRel gxYyMenuResourceRel);

    /**
     * 获取数据
     *
     * @param functionMenuId 功能菜单id
     * @return 影响行数
     */
    List<GxYyMenuResourceRel> getGxYyMenuResourceRelByFunctionMenuId(String functionMenuId);
    /**
     * 获取数据
     *
     * @param functionMenuIds 功能菜单id
     * @return 影响行数
     */
    List<GxYyMenuResourceRel> getByFunctionMenuIds(List<String> functionMenuIds);

    /**
     * 保存更新
     * @param gxYyMenuResourceRel
     */
    void saveOrUpdate(GxYyMenuResourceRel gxYyMenuResourceRel);
    /**
     * 保存更新--批量
     * @param gxYyMenuResourceRels
     */
    void saveOrUpdateBatch(List<GxYyMenuResourceRel> gxYyMenuResourceRels);

    /**
     * 根据functionMenuId删除
     * @param functionMenuId
     */
    void deleteByFunctionMenuId(String functionMenuId);

}

