package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyHtQlr;

import java.util.List;

/**
 * 不动产权利人表(GxYyHtQlr)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:45
 */
public interface GxYyHtQlrRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param qlrid 主键
     * @return 实例对象
     */
    GxYyHtQlr get(String qlrid);

    /**
     * 通过证件号查询数据
     *
     * @param sqid   申请id
     * @param qlrzjh 权利人证件号
     * @return 实例对象
     */
    List<GxYyHtQlr> getBySqidAndQlrzjh(String sqid, String qlrzjh);

    /**
     * 通过受理编号和证件号查询数据
     *
     * @param slbh   受理编号
     * @param qlrzjh 权利人证件号
     * @return 实例对象
     */
    List<GxYyHtQlr> getBySlbhAndQlrzjh(String slbh, String qlrzjh);

    /**
     * 通过sqid查询集合数据
     *
     * @param sqid
     * @return 实例对象
     */
    List<GxYyHtQlr> list(String sqid);

    /**
     * 新增数据
     *
     * @param GxYyHtQlr 实例对象
     * @return 影响行数
     */
    void save(GxYyHtQlr GxYyHtQlr);

    /**
     * 修改数据
     *
     * @param GxYyHtQlr 实例对象
     * @return 影响行数
     */
    void update(GxYyHtQlr GxYyHtQlr);

    /**
     * 保存或修改数据
     *
     * @param GxYyHtQlr 实例对象
     * @return
     */
    void saveOrUpdate(GxYyHtQlr GxYyHtQlr);

    /**
     * 批量保存或修改数据
     *
     * @param GxYyHtQlrList 实例对象
     * @return
     */
    void saveOrUpdateBatch(List<GxYyHtQlr> GxYyHtQlrList);

    /**
     * 根据sqid删除
     *
     * @param sqid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySqid(String sqid);

    /**
     * 根据sqid查询
     *
     * @param sqid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyHtQlr> selectQlrBySqid(String sqid);

    /**
     * 根据qlrid删除
     *
     * @param qlrid
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    int delete(String qlrid);

    /**
     * 根据sqidList和权利人类型
     *
     * @param sqidList
     * @param qlrlx
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    int deleteBySqidListAndQlrlx(List<String> sqidList, String qlrlx);

    /**
     * 根据sqidList和权利人类型删除
     *
     * @param sqid
     * @param qlrlx
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    int deleteBySqidAndQlrlx(String sqid, String qlrlx);


    /**
     * 根据sqid,qlrzjh查询
     *
     * @param sqid
     * @param qlrzjh
     * @param qlrlx
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYyHtQlr> get(String sqid, String qlrzjh, String qlrlx);

    /**
     * 根据sqid,qlrlx
     *
     * @param sqid
     * @param qlrlx
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYyHtQlr> getBySqidAndQlrlx(String sqid, String qlrlx);

    /**
     * 通过sqidList查询集合数据
     *
     * @param sqidList 主键
     * @return 实例对象
     */
    List<GxYyHtQlr> list(List<String> sqidList);

    /**
     * 通过sqidList查询集合数据
     *
     * @param sqidList 主键
     * @param qlrlx    权利人类型
     * @return 实例对象
     */
    List<GxYyHtQlr> getBySqidListAndQlrlx(List<String> sqidList, String qlrlx);

    /**
     * 通过slbh查询集合数据
     *
     * @param slbh
     * @return 实例对象
     */
    List<GxYyHtQlr> getBySlbh(String slbh);

    /**
     * 通过slbh，qlrlx查询集合数据
     *
     * @param slbh
     * @return 实例对象
     */
    List<GxYyHtQlr> getBySlbhAndQlrlx(String slbh, String qlrlx);

    /**
     * 获取是否满五唯一通过受理编号
     *
     * @param slbh
     * @return 实例对象
     */
    Boolean getSfmwwyBySlbh(String slbh);

    /**
     * 根据sqid集合删除
     *
     * @param sqidList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySqidList(List<String> sqidList);

    /**
     * 根据qlrid集合删除
     *
     * @param qlridList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteByQlridList(List<String> qlridList);

    /**
     * 批量保存
     *
     * @param GxYyHtQlrList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void saveBatch(List<GxYyHtQlr> GxYyHtQlrList);

    /**
     * 根据sqid和权利人证件号删除
     *
     * @param sqid
     * @param qlrzjhList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySqidAndQlrzjhList(String sqid, List<String> qlrzjhList);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 根据申请id查询并根据字段排序
     */
    List<GxYyHtQlr> listOrderAsc(String sqid, String order);
}

