package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.BasePage;
import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.model.GxYyFormModel;

import java.util.List;

/**
 * 组件库表(GxYyFormModel)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 14:19:33
 */
public interface GxYyFormModelRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param modelid 主键
     * @return 实例对象
     */
    GxYyFormModel get(String modelid);

    /**
     * 新增数据
     *
     * @param gxYyFormModel 实例对象
     * @return 影响行数
     */
    void save(GxYyFormModel gxYyFormModel);

    /**
     * 修改数据
     *
     * @param gxYyFormModel 实例对象
     * @return 影响行数
     */
    void update(GxYyFormModel gxYyFormModel);

    /**
     * 按照条件分页查询表单组件列表
     * @param gxYyFormModel
     * @param page
     * @return PageInfo<GxYyFormModel>
     */
    PageInfo<GxYyFormModel>
    queryPage(GxYyFormModel gxYyFormModel, BasePage page);

    /**
     * 删除
     * @param modelid
     */
    void delete(String modelid);

    /**
     * 通过modelIdList查询集合
     *
     * @param modelIdList 主键
     * @return 实例对象
     */
    List<GxYyFormModel> list(List<String> modelIdList);
}

