package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 单事项节点信息表(GxYyYjsJdxx)表实体类BO
 *
 * @author makejava
 * @since 2023-11-08 09:12:24
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyYjsJdxx implements Serializable {
    /**
     * 主键
     */
    private String uuid;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 单事项id
     */
    private String dsxid;

    /**
     * 节点名称（收件受理、审批、办结）
     */
    private String jdmc;

    /**
     * 推送时间
     */
    private Date tssj;

    /**
     * 状态（1：成功、0：失败）
     */
    private String status;

    /**
     * 入参
     */
    private String input;

    /**
     * 出参
     */
    private String output;

    /**
     * 异常信息
     */
    private String errmsg;


}

