package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 产权办件授权(GxYyCqbjsq)表实体类PO
 *
 * @author makejava
 * @since 2023-07-07 10:40:52
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyCqbjsq implements Serializable {
    private static final long serialVersionUID = 9006793508957167448L;
    /**
     * 主键
     */
    private String uuid;

    /**
     * 产权证号
     */
    private String cqzh;

    /**
     * 云签任务id
     */
    private String qsrwid;

    /**
     * 申请类型
     */
    private String sqlx;

    /**
     * 权利人名称
     */
    private String qlrmc;

    /**
     * 权利人证件号
     */
    private String qlrzjh;

    /**
     * 权利人联系电话
     */
    private String qlrlxdh;

    /**
     * 坐落
     */
    private String zl;

    /**
     * 中介机构名称
     */
    private String zjjgmc;

    /**
     * 中介机构证件号
     */
    private String zjjgzjh;

    /**
     * 中介代理人名称
     */
    private String dlrmc;

    /**
     * 中介代理人证件号
     */
    private String dlrzjh;

    /**
     * 创建时间
     */
    private Date cjsj;

    /**
     * 授权时间
     */
    private Date sqsj;

    /**
     * 授权时长（单位：天）
     */
    private String sqsc;

    /**
     * 授权结果（0:待授权，1：已授权，2：拒绝授权，3：授权已过期，4：授权请求作废,发起人重新发起）
     */
    private Integer sqjg;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 授权码（芜湖的合同号）
     */
    private String sqm;
    /**
     * 逻辑幢主键
     */
    private String fwDcbIndex;
    /**
     * 户室主键
     */
    private String fwHsIndex;
    /**
     * 区域代码
     */
    private String qydm;
}

