/**
 *
 */
package cn.gtmap.hlw.core.fun;

import cn.gtmap.hlw.core.enums.dict.RoleEnum;
import cn.gtmap.hlw.core.util.session.SessionUtil;
import org.apache.commons.lang3.StringUtils;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/8/1
 * @description 权限判断
 */
public class AuthFun {

    /**
     * 只有超管角色才可访问
     *
     * @return {boolean}
     */
    public boolean denyAll() {
        return hasRole(RoleEnum.BDGL_ROLE_GLY.getCode());
    }

    /**
     * 判断是否有该角色权限
     *
     * @param role 角色集合
     * @return {boolean}
     */
    public boolean hasAnyRole(String... role) {
        final String userRole = SessionUtil.getUser().getRoleId();
        if (StringUtils.isBlank(userRole)) {
            return false;
        }
        for (final String r : role) {
            if (StringUtils.equals(userRole, r)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 判断是否有该角色权限
     *
     * @param role 单角色
     * @return {boolean}
     */
    public boolean hasRole(String role) {
        return hasAnyRole(role);
    }

    /**
     * 放行所有请求
     *
     * @return {boolean}
     */
    public boolean permitAll() {
        return true;
    }

}
