package cn.gtmap.hlw.core.enums.menu;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 微信端
 *
 * @author admin
 * @Date 2023-06-25
 * @Version V1.0
 */
@Getter
@AllArgsConstructor
public enum AreaTypeEnum {
    /**
     * 顶部菜单
     */
    AREA_TYPE_TOP("0", "顶部菜单"),
    /**
     * 业务菜单
     */
    AREA_TYPE_YWCD("1", "业务菜单"),
    /**
     * 台账菜单
     */
    AREA_TYPE_DZCD("2", "台账菜单"),

    /**
     * 更多
     */
    AREA_TYPE_QT("3", "更多");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (AreaTypeEnum xq : AreaTypeEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}

