package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/8/30
 * @description 共有方式
 */
@Getter
@AllArgsConstructor
public enum TkGyfsEnum {
    /**
     * 是共有还是单独所有
     */
    TM_1("99", "共有单独所有题"),
    /**
     * 按份共有还是共同共有
     */
    TM_2("98", "按份共有共同共有题"),
    /**
     * 按份共有共有份额情况
     */
    TM_3("97", "按份共有共有份额情况题"),
    /**
     * 其他按份共有人是否同意
     */
    TM_4("96", "其他按份共有人是否同意题"),

    TM_5("95", "共有方式题");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (TkGyfsEnum xq : TkGyfsEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
