package cn.gtmap.hlw.core.dto.wct;

import cn.gtmap.hlw.core.base.BaseCommand;
import lombok.Data;

import java.util.Date;

/**
 * 核税明细表(WctJyHsxxmx)dto实体类
 *
 * @author makejava
 * @since 2023-07-21 13:40:13
 */
@Data
public class WctJyHsxxmxDTO extends BaseCommand {

    /**
     * 核税明细ID
     */
    private String hsxxmxid;

    /**
     * 核税信息ID
     */
    private String hsxxid;

    /**
     * 明细种类
     */
    private String mxzl;

    /**
     * 明细种类名称
     */
    private String mxzlmc;

    private String ynse;

    private String jmse;

    private String sjnse;

    /**
     * 计税金额
     */
    private String jsje;

    /**
     * 税率
     */
    private String sl;

    /**
     * 核税完成时间
     */
    private Date hswcsj;

    /**
     * 登记序号
     */
    private String djxh;

    /**
     * 凭证序号
     */
    private String pzxh;

    /**
     * 应征凭证序号
     */
    private String yzpzmxxh;

    /**
     * 应征凭证种类代码
     */
    private String yzpzzldm;

    /**
     * 税款所属期起
     */
    private String skssqq;

    /**
     * 税款所属期止
     */
    private String skssqz;

    /**
     * 缴款状态（0 未缴款 1已缴款）
     */
    private String jkzt;

    /**
     * 缴款返回信息
     */
    private String jkfhxx;

    /**
     * 电子税票号码
     */
    private String dzsphm;

}
