package cn.gtmap.hlw.core.dto.wct;

import cn.gtmap.hlw.core.base.BaseCommand;
import lombok.Data;

/**
 * 核税信息主表(WctJyHsxx)dto实体类
 *
 * @author makejava
 * @since 2023-07-21 13:40:13
 */
@Data
public class WctJyHsxxDTO extends BaseCommand {

    /**
     * 核税信息ID
     */
    private String hsxxid;

    private String hdjsjg;

    /**
     * 完税状态
     */
    private String wszt;

    /**
     * 完税状态名称
     */
    private String wsztmc;

    private String ynsehj;

    private String jmsehj;

    private String sjyzhj;

    /**
     * 税务机关代码
     */
    private String swjgdm;

    /**
     * 纳税人识别号
     */
    private String nsrsbh;

    /**
     * 税票号码
     */
    private String sphm;

    /**
     * 申请id
     */
    private String sqid;

    /**
     * 权利人类别
     */
    private String qlrlb;

    /**
     * 权利人类别名称
     */
    private String qlrlbmc;

    /**
     * 执收单位代码
     */
    private String zsdwdm;

    /**
     * 业务系统受理编号
     */
    private String ywxtslbh;

    /**
     * 执收单位名称
     */
    private String zsdwmc;

    /**
     * 收费收税信息id
     */
    private String sfssxxid;

    /**
     * 是否土地收益金（0:否，1：是）
     */
    private String sftdsyj;

    /**
     * 缴税方式（1：一卡清缴税模式，2：线下缴税）
     */
    private String jsfs;

    /**
     * 纳税人名称
     */
    private String nsrmc;

}
