package cn.gtmap.hlw.core.dto.third.cqxx.page;

import cn.gtmap.hlw.core.base.BasePage;
import lombok.Data;

import java.io.Serializable;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/7/17 13:52
 * @description 产权分页查询入参
 */
@Data
public class CqxxPageThirdQueryResultDTO extends BasePage implements Serializable {

    /**
     * 入参区域代码（前端传入的区域代码）
     */
    private String rcqydm;
    /**
     * 房产证号
     */
    private String fczh;
    /**
     * 不动产单元号
     */
    private String bdcdyh;

    /**
     * 坐落
     */
    private String zl;

    /**
     * 房屋面积
     */
    private String mj;

    /**
     * 权利人名称
     */
    private String qlrmc;

    /**
     * 权利人证件号
     */
    private String qlrzjh;

    /**
     * 抵押状态
     * 是否抵押（0是，1否） 放代码
     */
    private String sfdy;

    /**
     * 查封状态
     * 是否查封（0是，1否） 放代码
     */
    private String sfcf;

    /**
     * 锁定状态
     * 是否锁定 (0是，1否)
     */
    private String sfsd;

    /**
     * 异议状态
     * 是否异议 (0是，1否)
     */
    private String sfyy;

    /**
     * 不动产单元编号
     */
    private String bdcdybh;

    /**
     * 证书来源
     * 2 新数据 3 老数据
     */
    private String zsly;

    /**
     * 项目id
     * 存量数据主键
     * 增加xmid字段，为3.0业务数据主键
     */
    private String xmid;
    /**
     * 区域代码
     */
    private String qydm;
    /**
     * 区域名称
     */
    private String qymc;
    /**
     * 房屋用途
     */
    private String fwyt;
    /**
     * 房屋用途名称
     */
    private String fwytmc;

}
