package cn.gtmap.hlw.core.dto.platform;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author shenfei
 * @version 1.0
 * @description: 用户信息
 * @date 2025/8/6 15:07
 */
@Data
public class UserDTO {
    //  主键
    private String id;

    //  用户名/登陆账户，数字/字母
    private String username;

    //  别称（中文姓名）
    private String alias;

    //  1 ：管理员
    private int admin;

    // 0 ：禁用 1：启用
    private int enabled;

    //1 ：锁定 0：未锁
    private int locked;

    /**
     * 请假状态
     * 1：请假，0：正常
     */
    private Integer onLeave = 0;

    /**
     * 注册审批状态，默认为1：已审批通过，为0则是未审批，2是审批不通过
     */
    private Integer registerStatus = 1;

    // 签名ID, 通过ID从文档中心下载签名图片
    private String signId;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createAt;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateAt;

    //失效时间
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date expired;

    //密码
    private String password;

    //手机号
    private String mobile;

    // 邮件
    private String email;

    //办公电话
    private String tel;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date birthday;

    // 性别
    private String gender;

    // 职位
    private String title;

    // 岗位
    private String post;

    //个人简介
    private String resume;

    //地址
    private String address;

    //人员排序
    private String sequenceNumber;

    //身份证
    private String idCard;

    //证件类型： identity ： 身份证  passport：护照
    private String idCardType = "identity";

    //正面照片ID
    private String idCardFrontalId;

    //反面面照片ID
    private String idCardReverseId;

    // 0: 办公用户  10： 个人用户  20：企业用户
    private int userType = 0;

    //工号
    private String jobNumber;

    //是否入党
    private String partyMember = "N";

    // 照片ID
    private String pictureId;

    //CA证书编码
    private String caNumber;

    // 1: 已修改原始密码  0： 未原始密码
    private Integer modifyPwd = 0;

    /**
     * 毕业院校
     */
    private String graduateSchool;

    /**
     * 手机短号
     */
    private String shortNumber;

    /**
     * 传真
     */
    private String fax;

    /**
     * 工作年限
     */
    private Integer workingYears;

    /**
     * 入职日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date entryDate;
    private String usbKey;
    /**
     * 用户被锁定的类型
     * 0：管理员手动锁定，1：登录失败锁定，2：长时间未登录锁定
     */
    private String lockedType;

    private String creator;

    private String relUserId;

    private Integer link;
    //拥有角色列表
    private List<RoleDTO> roleRecordList;
}
