package cn.gtmap.hlw.core.dto.fj.upload;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/9/10
 * @description
 */
@Data
public class FjUploadGtdyResultDTO {
    private String id;
    /**
     * 应用ID
     */
    private String clientId;
    /**
     * 存储空间编码
     */
    private String spaceId;
    /**
     * 删除状态0 :删除， 1 正常
     */
    private Integer enabled;
    /**
     * 文件类型 0：目录 2: 图片 3： 文档 4： 视频 5：音乐，6：其他
     */
    private Integer type;
    /**
     * 文件名称
     */
    private String name;
    /**
     * 文件文件拥有者
     */
    private String owner;
    /**
     * 文件存储路径
     */
    private String path;
    /**
     * 文件下载路径
     */
    private String downUrl;
    /**
     * 文件层级 >= 0
     */
    private Integer weight;
    /**
     * 文件当前键值， onlyOffice 使用
     */
    private String currentKey;
    /**
     * 文件更新者， onlyOffice 使用， 用户Id
     */
    private String updatedBy;
    /**
     * 文件更新者， onlyOffice 使用， 用户Id
     */
    private Long currentVersion;
    /**
     * 文件长度
     */
    private Long fileSize;
    /**
     * 文件媒体类型  如：image/png
     */
    private String fileType;
    /**
     * 本地存储:local   阿里方式：oss   Hbase方式：hbase
     */
    private String storeType;
    /**
     * 文件上一级信息，主要键值Id
     */
    private FjUploadGtdyResultDTO parent;

    private List<FjUploadGtdyResultDTO> children;

    /**
     * 文件共享信息
     */
    private ShareDTO share;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createAt;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateAt;
}
