package cn.gtmap.hlw.core.domain.sqxx.model.tz;

import cn.gtmap.hlw.core.base.BasePage;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/29 17:06
 * @description 台账查询入参
 */
@Data
public class SqxxTzParamsModel extends BasePage {

    /** process 台账可能没有processId,那就上市 gx_yy_menu.FUNCTION_MENU_ID */
    private String processId;
    /** 领域事件代码 */
    private String lysjdm;
    
    
    /**
     * 当前用户信息 当前登陆人所属角色  此字段不作为查询条件
     */
    private String roleId;
    /** 登陆人 此字段对应 gx_yy_sqxx.create_userid */
    private String userGuid;
    /** 当前登陆人所属部门  此字段不作为查询条件，放在orgIdList作为查询条件*/
    private String orgId;

    //查询条件
    /** 本部门及下属之部门OrgId; gx_yy_sqxx.create_org_id */
    private List<String> orgIdList;
    /** 需要查询的SLZT gx_yy_sqxx.slzt */
    private List<String> slztList;
    /** 受理编号 gx_yy_sqxx.slbh */
    private String slbh;
    /** 权利人名称 gx_yy_sqxx.qlrmc ；不区分是否组合登记，都查 */
    private String qlrmc;
    /** 申请类型 gx_yy_sqxx.sqlx */
    private String sqlx;
    /** 坐落 gx_yy_sqxx.zl 支持模糊查询 */
    private String zl;
    /** 开始时间：yyyy-mm-dd 00:00:00  gx_yy_sqxx.create_date */
    private Date kssj;

    /** 开始时间：yyyy-mm-dd 23:59:59  gx_yy_sqxx.create_date */
    private Date jssj;

}
