package cn.gtmap.hlw.core.dao.role;


import cn.gtmap.hlw.core.model.GxYySqlxRoleRel;

import java.util.List;

/**
 * (GxYyRole)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-27 17:33:44
 */
public interface GxYySqlxRoleRelDao {
    /**
     * 删除数据
     *
     * @param roleId
     * @return 影响行数
     */
    void deleteByRoleId(String roleId);
    /**
     * 根据角色查询
     * @param roleId
     * @return:List<GxYySqlxRoleRelPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYySqlxRoleRel> getByRoleId(String roleId);
    /**
     * 根据sqlx删除
     * @param sqlx
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void deleteBySqlx(String sqlx);
    /**
     * 批量插入
     * @param sqlxRoleRelList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void insertBatch(List<GxYySqlxRoleRel> sqlxRoleRelList);
    /**
     * 根据sqlx查询
     * @param sqlx
     * @return:List<GxYySqlxRoleRelPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYySqlxRoleRel> listBySqlx(String sqlx);
    /**
     * 根据sqlx查询
     * @param sqlxList
     * @return:List<GxYySqlxRoleRelPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYySqlxRoleRel> listBySqlxList(List<String> sqlxList);
}

