package cn.gtmap.hlw.core.dao.flow;

import cn.gtmap.hlw.core.model.GxYyProcess;

import java.util.List;

/**
 * (GxYyProcess)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 15:07:05
 */
public interface GxYyProcessDao {

    /**
     * 通过ID查询单条数据
     *
     * @param processId 主键
     * @return 实例对象
     */
    GxYyProcess get(String processId);

    /**
     * 通过ID集合查询集合数据
     *
     * @param processIdList 主键集合
     * @return 实例对象集合
     */
    List<GxYyProcess> list(List<String> processIdList);

    /**
     * 新增数据
     *
     * @param gxYyProcess 实例对象
     * @return 影响行数
     */
    void saveProcess(GxYyProcess gxYyProcess);

    /**
     * 保存或更新
     *
     * @param gxYyProcess 实例对象
     * @return 影响行数
     */
    void saveOrUpdateProcess(GxYyProcess gxYyProcess);


    /**
     * 更新数据
     *
     * @param gxYyProcess
     */
    void update(GxYyProcess gxYyProcess);

    /**
     * 删除数据
     *
     * @param processId 主键
     * @return 影响行数
     */
    void delete(String processId);

    /**
     * 通过sqlx, clientType查询单条数据
     *
     * @param sqlx 申请类型
     * @param clientType 客户端类型
     * @param type
     * @return 实例对象
     */
    List<GxYyProcess> get(String sqlx, String clientType, String type);

    /**
     * 通过sqlx, clientType查询单条数据
     *
     * @param sqlx 申请类型
     * @param clientType 客户端类型
     * @param type 资源类型
     * @param roleId 角色id
     * @return 实例对象
     */
    List<GxYyProcess> get(String sqlx, String clientType, String type,String roleId);

    /**
     * 批量更新或保存
     *
     * @param gxYyProcessList 客户端类型
     * @return 实例对象集合
     */
    void saveOrUpdateBatchProcess(List<GxYyProcess> gxYyProcessList);

    /**
     * 根据sqlx查询
     * @param sqlx
     * @return:List<GxYyProcessPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYyProcess> listBySqlx(String sqlx);

    /**
     * 批量保存
     * @param gxYyProcessList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void insertBatchSomeColumn(List<GxYyProcess> gxYyProcessList);

    /**
     * 根据主键批量删除
     * @param processIdList
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    void removeByIds(List<String> processIdList);
    /**
     * 根据sqlx、clientType查询
     * @param sqlx
     * @param clientType
     * @return:java.util.List<cn.gtmap.hlw.core.model.GxYyProcess>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyProcess> listBySqlxAndClientType(String sqlx, String clientType);
}

