package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.dto.lysj.lysj.LysjListParamsDTO;
import cn.gtmap.hlw.core.model.GxYyLysj;
import cn.gtmap.hlw.core.model.LysjModel;

import java.util.List;

/**
 * 领域事件(GxYyLysj)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-06 14:39:57
 */
public interface GxYyLysjRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param lysjdm 主键
     * @return 实例对象
     */
    GxYyLysj get(String lysjdm);

    /**
     * 新增数据
     *
     * @param gxYyLysj 实例对象
     * @return 影响行数
     */
    void save(GxYyLysj gxYyLysj);

    /**
     * 修改数据
     *
     * @param gxYyLysj 实例对象
     * @return 影响行数
     */
    void update(GxYyLysj gxYyLysj);

    /**
     * 查询领域事件及其动作
     *
     * @param lysjdm    实例对象
     * @param processId
     * @return 影响行数
     */
    LysjModel queryLysjAndLydz(String lysjdm, String processId);

    /**
     * 查询领域事件及其动作
     *
     * @param lysjdm    实例对象
     * @param processId
     * @param anid
     * @return 影响行数
     */
    LysjModel queryLysjAndLydz(String lysjdm, String processId,String anid);

    /**
     * 查询领域事件及其动作
     *
     * @param lysjdm    实例对象
     * @param processId 流程代码
     * @param jddm 节点代码
     * @param sqlx 申请类型
     * @return 影响行数
     */
    LysjModel queryLysjAndLydz(String lysjdm, String processId, String jddm,String anid, String sqlx);

    /**
     * 领域事件代码信息
     *
     * @param lysjdms
     * @return
     */
    List<GxYyLysj> queryByLysjdmList(List<String> lysjdms);

    /**
     * 领域事件下拉
     * @param queryDTO
     * @return
     */
    List<GxYyLysj> list(LysjListParamsDTO queryDTO);
}

