package cn.gtmap.hlw.core.enums.menu;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 菜单类型
 *
 * @author admin
 * @Date 2023-06-25
 * @Version V1.0
 */
@Getter
@AllArgsConstructor
public enum CdlxEnum {
    /**
     * 目录
     */
    CDLX_ML("0", "目录"),
    /**
     * 功能
     */
    CDLX_GN("1", "功能"),
    /**
     * 主题
     */
    CDLX_ZT("2", "主题");


    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (CdlxEnum xq : CdlxEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}

