package cn.gtmap.hlw.core.dto.third.cqxx.page;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import lombok.Data;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/11/14
 * @description
 */
@Data
public class LjzPageThirdQueryResultDTO {
    /**
     * 逻辑幢主键
     */
    private String fwDcbIndex;

    /**
     * 隶属宗地
     */
    private String lszd;

    /**
     * 不动产单元号
     */
    private String bdcdyh;

    /**
     * 房屋层数
     */
    private String fwcs;

    /**
     * 坐落地址
     */
    private String zldz;

    /**
     * 房屋结构
     */
    private String fwjg2;

    /**
     * 总占地面积
     */
    private Double zzdmj;

    /**
     * 项目名称
     */
    private String xmmc;

    /**
     * 实测其他面积
     */
    private Double scqtmj;

    /**
     * 总套数
     */
    private Integer zts;

    /**
     * 房屋状态
     */
    private String fwzt;

    /**
     * 不动产单元房屋类型
     */
    private String bdcdyfwlx;

    /**
     * 房屋结构-中文
     */
    @ZdDzConfig(field = "fwjg", tableName = ZdDzConstant.ZD_DZ_FWJG, dmToDm = true)
    private String fwjg;

    /**
     * 房屋结构名称-中文
     */
    @ZdDzConfig(field = "fwjg", tableName = ZdDzConstant.ZD_DZ_FWJG, dmToMc = true)
    private String fwjgmc;
    /**
     * 栋号
     */
    private String dh;

    /**
     * 不动产状态
     */
    private String bdczt;

    /**
     * 竣工日期:格式 yyyy-MM-dd hh:mm:ss
     */
    private String jgrq;

    /**
     * 幢用地面积
     */
    private Double zydmj;

    /**
     * 地上层数
     */
    private Integer dscs;

    /**
     * 房屋用途3
     */
    private String fwyt3;

    /**
     * 房屋用途2
     */
    private String fwyt2;

    /**
     * 房屋名称
     */
    private String fwmc;

    /**
     * 备注
     */
    private String bz;

    /**
     * 要素代码
     */
    private String ysdm;

    /**
     * 房屋用途
     */
    @ZdTypeConfig(field = "fwyt", tableName = ZdTypeConstant.ZD_TYPE_FWYT, mcToDM = true)
    private String fwyt;

    /**
     * 逻辑幢号
     */
    private String ljzh;

    /**
     * 实测地下面积
     */
    private Double scdxmj;

    /**
     * 实测建筑面积
     */
    private Double scjzmj;

    /**
     * 自然幢号
     */
    private String zrzh;

    /**
     * 门牌号
     */
    private String mph;

    /**
     * 预测地下面积
     */
    private Double ycdxmj;

    /**
     * 预测建筑面积
     */
    private Double ycjzmj;

    /**
     * 预测其他面积
     */
    private Double ycqtmj;

    /**
     * 地下层数
     */
    private String dxcs;

    /**
     * 建筑物用途
     */
    private String jzwzt;

    /**
     * 房屋结构3
     */
    private String fwjg3;

    /**
     * 房屋项目信息主键
     */
    private String fwXmxxIndex;

    /**
     * 更新日期 格式 yyyy-MM-dd hh:mm:ss
     */
    private String gxrq;

    /**
     * 状态日期 格式 yyyy-MM-dd hh:mm:ss
     */
    private String ztrq;
    /**
     * 区域代码
     */
    private String qydm;
}
