package cn.gtmap.hlw.core.dto.fj.query;

import cn.gtmap.hlw.core.base.UserInfo;
import cn.gtmap.hlw.core.dto.third.cqxx.ZfxxQlrxxDTO;
import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/7/20 17:28
 * @description FjxmQueryParamsDTO
 */
@Data
public class FjxxParamsDTO {
    /**
     * slbh
     */
    private String slbh;
    /**
     * processId
     */
    private String processId;

    /**
     * 按钮id
     */
    private String anid;
    /**
     * lysjdm
     */
    private String lysjdm;

    /**
     * 以下是移交单参数 start
     */
    /**
     * 导出指定移交单数据，如果该字段为空，根据查询条件查询移交单数据
     */
    private List<String> slbhList;

    /**
     * 申请类型
     */
    private String sqlx;
    /**
     * 权利人名称
     */
    private String qlrmc;
    /**
     * 权利人证件号
     */
    private String qlrzjh;
    /**
     * 义务人名称
     */
    private String ywrmc;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 产权证号
     */
    private String cqzh;
    /**
     * 坐落
     */
    private String zl;
    /**
     * 开始时间：yyyy-mm-dd 00:00:00  gx_yy_sqxx.create_date
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date kssj;

    /**
     * 开始时间：yyyy-mm-dd 23:59:59  gx_yy_sqxx.create_date
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date jssj;
    /**
     * 导出状态
     */
    private String dczt;
    /**
     * 登陆人 此字段对应 gx_yy_sqxx.create_userid
     */
    private String userGuid;
    /**
     * 当前登陆人所属部门  此字段不作为查询条件，放在orgIdList作为查询条件
     */
    private String orgId;
    /** 本部门及下属之部门OrgId; gx_yy_sqxx.create_org_id */
    private List<String> orgIdList;

    /**
     * 是否加盖银行公章  1是 0 否
     */
    private String sfjgyhgz;
    /**
     * 区域代码
     */
    private String qydm;
    /**
     * xmid
     */
    private String xmid;
    /**
     * 不动产类型
     */
    private String bdclx;
    /**
     * id
     */
    private String id;

    /**
     * webUrl
     */
    private String webUrl;
    /**
     * 节点代码 节点事件需要
     */
    private String jddm;

    /**
     * 查询用途
     */
    private String cxyt;

    /**
     * 移交单号
     */
    private String yjdh;
    /**
     * 抵押业务类型
     */
    private String dyywlx;
    private String cqmj;
    private String fwytmc;
    /**
     * 入参-抵押权人
     */
    private String rcdyqr;
    /**
     * 家庭成员集合
     */
    private List<FjxxJtcyParamsDTO> jtcyList;
    /**
     * 当前登录用户信息（存在异步执行打印的情况，session取值当前登录人会存在取不到值的问题）
     */
    private UserInfo userInfo;

    /**
     * 查询土地使用权和建设用地使用权
     */
    private String queryTdsyqAndJsydsyq;

    /**
     * 权利人信息
     */
    private List<ZfxxQlrxxDTO> qlrxxList;

    /**
     * 未成年人姓名
     */
    private String wcnrxm;

    /**
     * 出生证明编号
     */
    private String cszmbh;

    /**
     * 母亲姓名
     */
    private String mqxm;

    /**
     * 母亲证件号
     */
    private String mqzjh;

    /**
     * 父亲姓名
     */
    private String fqxm;

    /**
     * 父亲证件号
     */
    private String fqzjh;
}
