package cn.gtmap.hlw.core.dao.resource;

import cn.gtmap.hlw.core.dto.resource.resource.ResourceListParamsDTO;
import cn.gtmap.hlw.core.model.GxYyResource;

import java.util.List;

/**
 * (GxYyResource)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 14:19:33
 */
public interface GxYyResourceDao {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyResource get(String id);

    /**
     * 获取数据
     *
     * @param resourcesIds 资源id集合
     * @return 影响行数
     */
    List<GxYyResource> getResourceByResourceIds(List<String> resourcesIds);

    /**
     * 获取数据
     *
     * @param resourcesIds 资源id集合
     * @return 影响行数
     */
    List<GxYyResource> getResourceByResourceIds(String resourcesIds);

    /**
     * 保存或更新
     *
     * @param gxYyResource 实例对象
     */
    void saveOrUpdateResource(GxYyResource gxYyResource);

    /**
     * 资源列表
     *
     * @param queryDTO
     * @return
     */
    List<GxYyResource> list(ResourceListParamsDTO queryDTO);

    /**
     * 保存或更新
     *
     * @param gxYyResource 实例对象
     */
    void saveOrUpdateR(GxYyResource gxYyResource);

    /**
     * 批量保存
     *
     * @param resourceList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatchSomeColumn(List<GxYyResource> resourceList);

    /**
     * 根据资源id集合删除
     *
     * @param resourceIdList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteByResourceIdList(List<String> resourceIdList);

    /**
     * @param resourceId
     * @return:GxYyResourcePO
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyResource getByResourceId(String resourceId);

    void saveOrUpdateBatch(List<GxYyResource> resourcePoList);

    void updateById(GxYyResource resource);
}

