/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.validator;

import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;

public class IdCardVailatorUtils {
    public static String getSexName(String zjh) {
        if (zjh == null || zjh.length() != 18) {
            return null;
        }
        int genderCode = Integer.parseInt(zjh.substring(16, 17));
        if (genderCode % 2 == 0) {
            return "\u5973";
        }
        return "\u7537";
    }

    public static Boolean checkCn(String zjh) {
        LocalDate currentDate;
        DateTimeFormatter formatter;
        if (zjh == null || zjh.length() != 18) {
            return false;
        }
        String birthdayStr = zjh.substring(6, 14);
        LocalDate birthDate = LocalDate.parse(birthdayStr, formatter = DateTimeFormatter.ofPattern("yyyyMMdd"));
        Period period = Period.between(birthDate, currentDate = LocalDate.now());
        int age = period.getYears();
        return age >= 18;
    }
}

