/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.file;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportJson(HttpServletResponse response, Object obj, String uploadPath, String fileName) {
        FileInputStream fis = null;
        OutputStream os = null;
        try {
            fileName = fileName.replaceAll("[\\\\/]", "_");
            String jsonString = JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
            String fullPath = uploadPath + File.separator + "export";
            FileUtil.mkdir((String)fullPath);
            File file = new File(fullPath + File.separator + fileName);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                writer.write(jsonString);
                ((Writer)writer).flush();
            }
            fis = new FileInputStream(file);
            response.setContentType("application/force-download");
            response.setHeader("Content-Disposition", "attachment;filename=".concat(String.valueOf(URLEncoder.encode(fileName, "UTF-8"))));
            response.setCharacterEncoding("utf-8");
            os = response.getOutputStream();
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = fis.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            log.error("exportJson", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error("exportJson", (Throwable)e);
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    log.error("exportJson", (Throwable)e);
                }
            }
        }
    }
}

