/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption.sm4;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.symmetric.SM4;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sm4Util {
    private static Logger logger = LoggerFactory.getLogger(Sm4Util.class);
    public static final String ALGORITHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";
    public static final int DEFAULT_KEY_SIZE = 128;

    public static String generateKey() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        return new String(Hex.encodeHex((byte[])Sm4Util.generateKey(128), (boolean)false));
    }

    public static byte[] generateKey(int keySize) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_NAME, "BC");
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, sm4Key);
        return cipher;
    }

    @Deprecated
    public static String encryptEcb(String hexKey, String paramStr) {
        try {
            String cipherText = "";
            byte[] keyData = ByteUtils.fromHexString((String)hexKey);
            byte[] srcData = paramStr.getBytes(StandardCharsets.UTF_8);
            byte[] cipherArray = Sm4Util.encryptEcbPadding(keyData, srcData);
            cipherText = ByteUtils.toHexString((byte[])cipherArray);
            return cipherText;
        }
        catch (Exception e) {
            return paramStr;
        }
    }

    public static String encryptEcbByHutool(String hexKey, String paramStr) {
        byte[] keyBytes = HexUtil.decodeHex((String)hexKey);
        SM4 sm4Engine = new SM4(Mode.ECB, Padding.PKCS5Padding, keyBytes);
        return sm4Engine.encryptHex(paramStr);
    }

    public static byte[] encryptEcbPadding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = Sm4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 1, key);
        return cipher.doFinal(data);
    }

    public static String decryptEcb(String hexKey, String cipherText) {
        String decryptStr = "";
        byte[] keyData = ByteUtils.fromHexString((String)hexKey);
        byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
        byte[] srcData = new byte[]{};
        try {
            srcData = Sm4Util.decryptEcbPadding(keyData, cipherData);
            decryptStr = new String(srcData, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.error("\u89e3\u5bc6\u5931\u8d25\uff1a", (Throwable)e);
        }
        return decryptStr;
    }

    public static String decryptEcbThrowException(String hexKey, String cipherText) throws Exception {
        String decryptStr = "";
        byte[] keyData = ByteUtils.fromHexString((String)hexKey);
        byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
        byte[] srcData = new byte[]{};
        srcData = Sm4Util.decryptEcbPadding(keyData, cipherData);
        decryptStr = new String(srcData, StandardCharsets.UTF_8);
        return decryptStr;
    }

    public static byte[] decryptEcbPadding(byte[] key, byte[] cipherText) throws Exception {
        Cipher cipher = Sm4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    public static boolean verifyEcb(String hexKey, String cipherText, String paramStr) throws Exception {
        boolean flag = false;
        byte[] keyData = ByteUtils.fromHexString((String)hexKey);
        byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
        byte[] decryptData = Sm4Util.decryptEcbPadding(keyData, cipherData);
        byte[] srcData = paramStr.getBytes(StandardCharsets.UTF_8);
        flag = Arrays.equals(decryptData, srcData);
        return flag;
    }

    public static String cbcDecrypt(String text, String key, String iv) {
        return Sm4Util.decrypt(text, key, iv, Mode.CBC.name(), Padding.PKCS5Padding.name());
    }

    public static String decrypt(String text, String key, String iv, String mode, String padding) {
        byte[] ivBytes = null;
        try {
            ivBytes = Base64.getDecoder().decode(iv);
        }
        catch (Exception e) {
            ivBytes = iv.getBytes(CharsetUtil.CHARSET_UTF_8);
        }
        return new SM4(mode, padding, Sm4Util.getKey(key), ivBytes).decryptStr(text);
    }

    private static byte[] getKey(String key) {
        if (key.length() == 32) {
            return HexUtil.decodeHex((String)key);
        }
        if (key.length() == 16) {
            return key.getBytes();
        }
        return null;
    }
}

