package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2025/5/31 15:20
 * @description 定时任务(GxYyDsrw)表实体类BO
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyDsrw implements Serializable {

    private static final long serialVersionUID = -6919142232349627812L;

    /**
     * 任务ID
     */
    private String dsrwid;

    /**
     * 任务名称
     */
    private String rwmc;

    /**
     * 任务组名
     */
    private String rwzm;

    /**
     * 执行规则（cron定时任务表达式）
     */
    private String zxgz;

    /**
     * 任务状态（正常 暂停）
     */
    private String rwzt;

    /**
     * 任务状态更新时间
     */
    private Date rwztgxsj;

    /**
     * 上次执行时间
     */
    private Date sczxsj;

    /**
     * 是否使用token, 1：使用， 0：不使用
     */
    private String sfsytoken;

    /**
     * token关键字
     */
    private String tokengjz;

    /**
     * 接口入参
     */
    private String jkrc;

    /**
     * 接口请求方式：GET,POST
     */
    private String jkqqfs;

    /**
     * 是否异步执行，0：否，1：是，默认是：0'
     */
    private String sfybzx;

    /**
     * 接口地址
     */
    private String jkdz;
}

