package cn.gtmap.hlw.core.dto.third.cqxx.bjjd;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2024/2/7
 * @description 办件进度查询出参
 */
@Data
public class BjjdThirdResultDTO {

    /**
     * 业务系统受理编号
     */
    private String ywxtslbh;
    /**
     * 流程名称
     */
    private String lcmc;
    /**
     * 受理日期
     */
    private String slsj;
    /**
     * 办件状态
     */
    @ZdDzConfig(field = "bjzt", tableName = ZdDzConstant.ZD_DZ_BJJD, mcToMc = true)
    private String bjzt;
    /**
     * 申请类型代码
     */
    private String sqlxdm;
    /**
     * 申请类型名称
     */
    private String sqlxmc;
    /**
     * 受理日期
     */
    private String slrq;
    /**
     * 办理状态
     */
    private String blzt;
    /**
     * 工作流定义id
     */
    private String gzldyid;
    /**
     * 权利人名称
     */
    private String qlrmc;
    /**
     * 申请人信息
     */
    private List<BjjdThirdSqrxxResultDTO> sqrxx;
    /**
     * 单元信息
     */
    private List<BjjdThirdDyxxResultDTO> dyxx;
    /**
     * 节点信息
     */
    private List<BjjdThirdJdxxResultDTO> jdxx;
    /**
     * 物流单号
     */
    private String wldh;
    /**
     * 退回原因
     */
    private String thyy;

    /**
     * 过户信息
     */
    private BjjdThirdYjfwxxResultDTO ghxx;
    /**
     * 物流信息
     */
    private BjjdThirdWlxxResultDTO wlxx;
}
