package cn.gtmap.hlw.core.dto.sw.hs;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import lombok.Data;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/7/18
 * @description 房源基本信息
 */
@Data
public class SwHsFyjbxxDTO {
    /**
     * 房源基本信息UUID
     */
    private String fyjbxxuuid;
    /**
     * 外部 ID
     */
    private String wbid;
    /**
     * 不动产单元代码
     */
    private String bdcdyh;
    /**
     * 行政区划代码
     */
    @ZdDzConfig(field = "xzqhszdm", tableName = ZdDzConstant.ZD_DZ_XZQH, dmToDm = true)
    private String xzqhszdm;
    /**
     * 街道乡镇代码
     */
    private String jdxzdm;
    /**
     * 土地房屋地址
     */
    private String tdfwdz;
    /**
     * 土地使用证编号
     */
    private String tdsyzbh;
    /**
     * 土地税源编号
     */
    private String tdsybh;
    /**
     * 房屋栋号
     */
    private String fwzh;
    /**
     * 单元号
     */
    private String dyh;
    /**
     * 楼层
     */
    private String lc2;
    /**
     * 房间号
     */
    private String fjh;
    /**
     * 建筑结构代码
     */
    @ZdDzConfig(field = "jzjglxdm", tableName = ZdDzConstant.ZD_DZ_FWJG, dmToDm = true)
    private String jzjglxdm;
    /**
     * 朝向代码
     */
    @ZdDzConfig(field = "cxdm", tableName = ZdDzConstant.ZD_DZ_FWCX, dmToDm = true, defaultValue = "02")
    private String cxdm;
    /**
     * 面积
     */
    private Double mj;
    /**
     * 套内面积
     */
    private Double tnmj;
    /**
     * 阁楼面积
     */
    private Double glmj;
    /**
     * 储藏室面积
     */
    private Double ccsmj;
    /**
     * 自行车车库面积
     */
    private Double zxcckmj;
    /**
     * （汽车）车库面积
     */
    private Double ckmj;
    /**
     * 建筑年份
     */
    private String jznf;
    /**
     * 道路名称
     */
    private String dlmc;
    /**
     * 小区名称
     */
    private String xqmc;
    /**
     * 楼层总数
     */
    private String lczs;
    /**
     * 房屋/土地总价格
     */
    private Double fwtdzjg;
    /**
     * 房源信息来源  1 交易信息（住建） 、2 交易信息（不动产） 、 3 一窗前台采集、 4 一窗纳税人输入
     */
    private String fyxxly;
    /**
     * 数据归属地区
     */
    private String sjgsdq;
    /**
     * 存量房物业类型
     */
    @ZdDzConfig(field = "clfwylx", tableName = ZdDzConstant.ZD_DZ_FWLX, dmToDm = true)
    private String clfwylx;
    /**
     * 备注
     */
    private String bz;

    /**
     * 东西至
     */
    private String dxz;
    /**
     * 地市代码
     */
    private String xzqhds;
    /**
     * 县区代码
     */
    private String xzqhxq;
    /**
     * 街道
     */
    private String xzqhjd;
    /**
     * 小区代码
     */
    private String xqdm;
    /**
     * 房屋坐落地址
     */
    private String fwzldz;
    /**
     * 房屋性质小类
     */
    private String fwxzxl;
    /**
     * 用途
     */
    private String yt;
    /**
     * 房屋结构
     */
    private String fwjg;
    /**
     * 商铺面积一层
     */
    private String spmjyc;
    /**
     * 商铺面积二层
     */
    private String spmjec;
    /**
     * 商铺面积三层
     */
    private String spmjsc;
    /**
     * 商铺面积四层及四层以上
     */
    private String spmjsicys;
    /**
     * 商铺面积地下室或半地下室
     */
    private String spmjdxshbdxs;
    /**
     * 钢结构厂房、仓库
     */
    private String gjgcfck;
    /**
     * 钢砼厂房、仓库
     */
    private String gtcfck;
    /**
     * 砖混结构厂房、仓库
     */
    private String zhjgck;
}
