/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.es;

import cn.gtmap.hlw.core.util.es.Pair;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ESClient {
    @Autowired
    private RestHighLevelClient restHighLevelClient;

    public boolean createIndex(String index, String type, Settings.Builder settings, XContentBuilder mappings) throws IOException {
        CreateIndexRequest request = new CreateIndexRequest(index).settings(settings).mapping(type, mappings);
        try {
            return this.restHighLevelClient.indices().create(request, new Header[0]).isAcknowledged();
        }
        catch (ElasticsearchStatusException e) {
            if (e.status() == RestStatus.BAD_REQUEST && e.getMessage().contains("resource_already_exists_exception")) {
                System.out.println("\u7d22\u5f15\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u521b\u5efa\u3002");
                return true;
            }
            throw e;
        }
    }

    public CreateIndexResponse createIndex(String index, String jsonMapping) throws IOException {
        CreateIndexRequest request = new CreateIndexRequest(index);
        request.source(jsonMapping, XContentType.JSON);
        return this.restHighLevelClient.indices().create(request, new Header[0]);
    }

    public boolean deleteIndex(String index) throws IOException {
        DeleteIndexRequest deleteRequest = new DeleteIndexRequest(index);
        DeleteIndexResponse response = this.restHighLevelClient.indices().delete(deleteRequest, new Header[0]);
        return response.isAcknowledged();
    }

    public IndexResponse createDocument(String index, String type, String id, String jsonString) throws IOException {
        IndexRequest request = new IndexRequest(index).type(type).id(id).source(jsonString, XContentType.JSON);
        return this.restHighLevelClient.index(request, new Header[0]);
    }

    public IndexResponse createDocument(String index, String jsonString) throws IOException {
        IndexRequest request = new IndexRequest(index).source(jsonString, XContentType.JSON);
        return this.restHighLevelClient.index(request, new Header[0]);
    }

    public String getDocument(String index, String type, String id) throws IOException {
        GetRequest request = new GetRequest(index, type, id);
        return this.restHighLevelClient.get(request, new Header[0]).getSourceAsString();
    }

    public boolean deleteDocument(String index, String type, String id) throws IOException {
        DeleteRequest deleteRequest = new DeleteRequest(index, type, id);
        DocWriteResponse.Result result = this.restHighLevelClient.delete(deleteRequest, new Header[0]).getResult();
        return result == DocWriteResponse.Result.DELETED;
    }

    public UpdateResponse updateDocument(String index, String type, String id, String jsonString) throws IOException {
        UpdateRequest request = new UpdateRequest(index, type, id).doc(jsonString, XContentType.JSON);
        return this.restHighLevelClient.update(request, new Header[0]);
    }

    public SearchResponse searchDocuments(String index, SearchSourceBuilder query) throws IOException {
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        searchRequest.source(query);
        return this.restHighLevelClient.search(searchRequest, new Header[0]);
    }

    public <T> BulkResponse bulkCreateDocument(String index, List<Pair<String, T>> dataList) throws IOException {
        BulkRequest request = new BulkRequest();
        for (Pair<String, T> pair : dataList) {
            request.add(new IndexRequest(index).id(pair.getKey()).source(JSON.toJSONString(pair.getValue()), XContentType.JSON));
        }
        return this.restHighLevelClient.bulk(request, new Header[0]);
    }

    public BulkResponse bulkDeleteDocument(String index, String type, List<String> idList) throws IOException {
        BulkRequest request = new BulkRequest();
        for (String id : idList) {
            request.add(new DeleteRequest(index, type, id));
        }
        return this.restHighLevelClient.bulk(request, new Header[0]);
    }
}

