package cn.gtmap.hlw.coredk.enums.error;

import cn.gtmap.hlw.coredk.exception.ExchangeError;
import lombok.Getter;

public enum ExchangeErrorEnum implements ExchangeError {
    /**
     * 成功
     */
    SUCCESS("0000", "success"),

    /**
     * 失败
     */
    FAIL("0001", "fail"),

    JKGL_PZX_ERROR("0003", "接口配置不存在"),
    JKGL_PZX_JKSX_ERROR("0003", "接口配置不存在实现方法"),
    /** 无效签名 code码 */
    SIGNATURE_VERIFICATION_ERROR("6001", "无效签名"),
    /** token过期 code码 */
    TOKEN_EXPIRED_ERROR("6002", "token过期"),
    /** token算法不一致 code码 */
    ALGORITHM_MISMATCH_ERROR("6003", "token算法不一致"),
    /** token信息为空 code码 */
    EMPTY_TOKEN_ERROR("6004", "token信息为空"),
    /** token失效 code码 */
    OTHER_TOKEN_ERROR("6005", "token失效"),

    /**
     * 自定义异常，不需要放内容，具体内容有代码内自定义
     */
    ADD_ERROR("9999", "");



    @Getter
    private String code;

    @Getter
    private String msg;

    ExchangeErrorEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }
}
