package cn.gtmap.hlw.core.util.string;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @Author jianglin
 * @Date 2025/9/28
 * @Description
 */
@Slf4j
public class PublicUtil {
    /**
     * json数组转对象列表
     * 不抛出异常
     * @param obj
     * @param tClass
     * @return
     */
    public static <T> List<T> getBeanListByJsonArray(Object obj, Class<T> tClass) {
        List<T> t = null;
        try {
            if (obj instanceof String) {
                t = JSON.parseArray(obj.toString(), tClass);
            } else {
                t = JSON.parseArray(JSON.toJSONString(obj), tClass);
            }
        } catch (Exception e) {
            //logger.error(e.getMessage());
            log.error("getBeanListByJsonArray:" + e.getMessage());
        }
        return t;
    }

    /**
     * json对象转对象
     * 不抛出异常
     * @param json
     * @param tClass
     * @return
     */

    public static <T> T getBeanByJsonObj(Object json, Class<T> tClass) {
        T t = null;
        try {
            //t = JSON.parseObject(JSON.toJSONString(json), tClass);
            if (json instanceof String) {
                //防止String类型被JSON.toJSONString(json)时，外面包裹一层""；无法转成JSON对象
                t = JSON.parseObject(json.toString(), tClass);
            } else {
                t = JSON.parseObject(JSON.toJSONString(json), tClass);
            }
        } catch (Exception e) {
            log.error("getBeanByJsonObj:"+e.getMessage());
        }
        return t;
    }

    /**
     * @param
     * @return
     * @author <a href="mailto:liwenwu@gtmap.cn">liwenwu</a>
     * @version 2.0,
     * @description 根据手机号生成随机用户名
     */
    public static String getUserNameByLxdh(String lxdh) {
        String userName = null;
        //生成规则：yhm+手机号末四位+6位随机数字
        if (StringUtils.isNotBlank(lxdh)) {
            userName = "yhm" + lxdh.substring(lxdh.length() - 4, lxdh.length()) + RandomStringUtils.randomNumeric(6);
            ;
        }
        return userName;
    }

    /**
     * @param
     * @return
     * @author <a href="mailto:liwenwu@gtmap.cn">liwenwu</a>
     * @version 2.0,
     * @description 将字符串和数组里的字符串进行对比，存在即返回true
     */
    public static boolean compareString(String target, List<String> source) {
        if (StringUtils.isNotBlank(target) && source.size() > 0) {
            for (String compare : source) {
                if (StringUtils.equals(compare, target)) {
                    return true;
                }
            }
            return false;
        } else {
            return false;
        }
    }
}
