package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.sqxx.tz.SqxxTzParamsDTO;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYySqxxLb;

import java.util.List;

/**
 * 不动产申请信息表(GxYySqxxLb)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:45
 */
public interface GxYySqxxLbRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param sqid 主键
     * @return 实例对象
     */
    GxYySqxxLb get(String sqid);

    /**
     * 通过slbh查询集合数据
     *
     * @param slbh
     * @return 实例对象
     */
    List<GxYySqxxLb> list(String slbh);

    /**
     * 通过sqid查询集合数据
     *
     * @param sqidList
     * @return 实例对象
     */
    List<GxYySqxxLb> listBySqid(List<String> sqidList);

    /**
     * 新增数据
     *
     * @param gxYySqxxLb 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxLb gxYySqxxLb);

    /**
     * 修改数据
     *
     * @param gxYySqxxLb 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxLb gxYySqxxLb);


    /**
     * 删除数据
     *
     * @param slbh 受理编号
     * @return 影响行数
     */
    int delete(String slbh);

    /**
     * 批量删除数据
     *
     * @param sqidList 申请id集合
     * @return 影响行数
     */
    int deleteBatchIds(List<String> sqidList);

    /**
     * 保存或修改数据
     *
     * @param gxYySqxx 实例对象
     * @return
     */
    void saveOrUpdate(GxYySqxx gxYySqxx);

    /**
     * 分页查询
     *
     * @param queryDTO
     * @return
     */
    PageInfo<GxYySqxxLb> page(SqxxTzParamsDTO queryDTO);
}

