package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqlxJdxxZt;

import java.util.List;
import java.util.Map;

/**
 * 节点信息状态(GxYySqlxJdxxZt)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 15:07:05
 */
public interface GxYySqlxJdxxZtRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param jdztid 主键
     * @return 实例对象
     */
    GxYySqlxJdxxZt get(String jdztid);

    /**
     * 新增数据
     *
     * @param gxYySqlxJdxxZt 实例对象
     * @return 影响行数
     */
    void save(GxYySqlxJdxxZt gxYySqlxJdxxZt);

    /**
     * 修改数据
     *
     * @param gxYySqlxJdxxZt 实例对象
     * @return 影响行数
     */
    void update(GxYySqlxJdxxZt gxYySqlxJdxxZt);

    void deleteBySlbh(String slbh);

    /**
     * 根据受理编号查询申请类型节点信息
     * @param slbh
     * @return
     */
    List<GxYySqlxJdxxZt> queryBySlbh(String slbh);

    /**
     * 执行成功
     * @param slbh
     * @param jddm
     */
    void updateToSucess(String slbh, String jddm);

    /**
     * 批量执行成功
     * @param slbh 受理编号
     * @param jddmList 节点代码集合
     */
    void updateToSucessBatch(String slbh, List<String> jddmList);

    /**
     * 更新节点状态
     * @param slbh 受理编号
     * @param jddm 节点代码
     * @param jdzt 节点状态
     */
    void updateJdzt(String slbh, String jddm, String jdzt);

    /**
     * 无需执行
     * @param slbh
     * @param jddm
     */
    void updateNoNeedExecute(String slbh, String jddm);

    /**
     * 执行中
     * @param slbh
     * @param jddm
     */
    void updateToExecute(String slbh, String jddm);

    /**
     * 执行失败
     * @param slbh
     * @param jddm
     * @param ycxx
     */
    void updateFaill(String slbh, String jddm, String ycxx);
    /**
     * 批量新增数据
     *
     * @param sqlxJdxxZtList 实例对象
     * @return 影响行数
     */
    void saveBatch(List<GxYySqlxJdxxZt> sqlxJdxxZtList);

    /**
     * 批量更新或插入
     *
     * @param sqlxJdxxZtList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYySqlxJdxxZt> sqlxJdxxZtList);

    /**
     * 获取当前节点名称
     * @param slbhList
     * @return:String
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    Map getCurJdmc(List<String> slbhList);
    /**
     * 更新节点状态
     * @param slbh
     * @param jddmList
     * @param code
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void updateJdzt(String slbh, List<String> jddmList, String code);

    /**
     * 通过受理编号和节点代码获取数据
     * @param slbh 受理编号
     * @param jddm 节点代码
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    GxYySqlxJdxxZt getBySlbhAndJddm(String slbh, String jddm);

    /**
     * 通过受理编号和节点代码集合获取数据
     * @param slbh 受理编号
     * @param jddmList 节点代码集合
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYySqlxJdxxZt> getBySlbhAndJddmList(String slbh, List<String> jddmList);
}

