package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyRoleOrgRel;

import java.util.List;

/**
 * (GxYyRoleOrgRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface GxYyRoleOrgRelRepository {

    List<GxYyRoleOrgRel> getByOrgIdList(List<String> orgIdList);

    /**
     * 通过ID查询单条数据
     *
     * @param roleOrgRelId 主键
     * @return 实例对象
     */
    GxYyRoleOrgRel get(String roleOrgRelId);

    /**
     * 通过roleId查询数据
     *
     * @param roleId
     * @return 实例对象
     */
    List<GxYyRoleOrgRel> getByRoleId(String roleId);

    /**
     * 新增数据
     *
     * @param gxYyRoleOrgRel 实例对象
     * @return 影响行数
     */
    void save(GxYyRoleOrgRel gxYyRoleOrgRel);

    void saveOrUpdateG(GxYyRoleOrgRel gxYyRoleOrgRel);

    /**
     * 修改数据
     *
     * @param gxYyRoleOrgRel 实例对象
     * @return 影响行数
     */
    void update(GxYyRoleOrgRel gxYyRoleOrgRel);

    /**
     * 获取数据
     *
     * @return 影响行数
     */
    List<GxYyRoleOrgRel> getAll();

    /**
     * 删除数据
     *
     * @param roleOrgRelId
     * @return 影响行数
     */
    int delete(String roleOrgRelId);

    void deleteByOrgId(String orgId);

    /**
     * 根据部门id查询
     *
     * @param orgId
     * @return:GxYyRoleOrgRel
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyRoleOrgRel getByOrgId(String orgId);
}

