package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.BasePage;
import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.model.GxYyOrgDz;

import java.util.List;

/**
 * (GxYyOrgDz)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 13:37:18
 */
public interface GxYyOrgDzRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param dzid 主键
     * @return 实例对象
     */
    GxYyOrgDz get(Integer dzid);

    /**
     * 新增数据
     *
     * @param gxYyOrgDz 实例对象
     * @return 影响行数
     */
    void save(GxYyOrgDz gxYyOrgDz);

    /**
     * 修改数据
     *
     * @param gxYyOrgDz 实例对象
     * @return 影响行数
     */
    void update(GxYyOrgDz gxYyOrgDz);

    /**
     * 获取数据
     *
     * @return 影响行数
     */
    List<GxYyOrgDz> getAll(String orgId);

    /**
     * 删除数据
     *
     * @param dzid
     * @return 影响行数
     */
    int delete(String dzid);

    /**
     * 分页查询
     *
     * @param orgId 公司id
     * @param dzid  对照id
     * @param page
     * @return 影响行数
     */
    PageInfo<GxYyOrgDz> queryPage(String orgId, String dzid, BasePage page);

    /**
     *根据org_id和name去查询
     */
    GxYyOrgDz selectOrganizeDzByOrgIdAndMc(String orgId,String orgNameDz);
    /**
     * 根据部门id查询
     * @param orgId
     * @return:java.util.List<cn.gtmap.hlw.domain.user.model.GxYyOrgDz>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyOrgDz> listByOrgid(String orgId);
}

