package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyCqbjsq;
import cn.gtmap.hlw.core.model.query.CqbjsqParamsModel;

import java.util.List;
import java.util.Map;

/**
 * 产权办件授权(GxYyCqbjsq)表数据库访问层
 *
 * @author makejava
 * @since 2023-07-07 10:41:06
 */
public interface GxYyCqbjsqRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param uuid 主键
     * @return 实例对象
     */
    GxYyCqbjsq get(String uuid);

    /**
     * 新增数据
     *
     * @param gxYyCqbjsq 实例对象
     * @return 影响行数
     */
    void save(GxYyCqbjsq gxYyCqbjsq);

    /**
     * 修改数据
     *
     * @param gxYyCqbjsq 实例对象
     * @return 影响行数
     */
    void update(GxYyCqbjsq gxYyCqbjsq);

    /**
     * 修改数据
     *
     * @param gxYyCqbjsq 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYyCqbjsq gxYyCqbjsq);

    /**
     * 获取数据
     *
     * @param paramsModel 参数对象
     * @return 影响行数
     */
    GxYyCqbjsq getByParams(CqbjsqParamsModel paramsModel);

    /**
     * 查询产权办件授权
     *
     * @param paramMap
     * @return:List<GxYyCqbjsq>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyCqbjsq> getListByMap(Map<String, Object> paramMap);
    /**
     * 查询产权办件授权
     *
     * @param zjhList
     * @param fczhList
     * @return:List<GxYyCqbjsq>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyCqbjsq> getByZjhAndFczh(List<String> zjhList,List<String> fczhList);

    int delete(String uuid);

    /**
     * 根据签署任务获取信息
     * @param qsrwid
     * @return
     */
    GxYyCqbjsq getByQsrwid(String qsrwid);

    List<GxYyCqbjsq> getByFwDcbIndex(String fwDcbIndex);
    List<GxYyCqbjsq> getByZjid(String zjid);

    GxYyCqbjsq getByFwHsIndex(String fwHsIndex);
    /**
     * 根据bdcdyh查询
     * @param bdcdyh
     * @return:cn.gtmap.hlw.domain.sqxx.model.GxYyCqbjsq
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyCqbjsq getByBdcdyh(String bdcdyh);
    /**
     * 批量保存
     * @param gxYyCqbjsqList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void saveBatch(List<GxYyCqbjsq> gxYyCqbjsqList);
    /**
     * 根据sqm查询
     * @param sqm
     * @return:java.util.List<cn.gtmap.hlw.domain.sqxx.model.GxYyCqbjsq>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyCqbjsq> getBySqm(String sqm);
    /**
     * 批量更新保存
     * @param list
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void saveOrUpdateBatch(List<GxYyCqbjsq> list);
}

