package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * 历史--在线申请--林地信息(HgxYySqxxLdxx)表实体类BO
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2023-08-09 17:24:35
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HgxYySqxxLdxx implements Serializable {
    private static final long serialVersionUID = -7235321460560117886L;
    private Integer ldxxid;

    /**
     * 受理编号（与sqxx表关联）
     */
    private String slbh;

    /**
     * 林地面积
     */
    private String ldmj;

    /**
     * 小地名
     */
    private String xdm;

    /**
     * 林班
     */
    private String lb;

    /**
     * 小班
     */
    private String xb;

    /**
     * 株树
     */
    private String zs;

    /**
     * 四至东
     */
    private String szd;

    /**
     * 四至南
     */
    private String szn;

    /**
     * 四至北
     */
    private String szb;

    /**
     * 四至西
     */
    private String szx;

    /**
     * 造林年度
     */
    private String zlnd;

    /**
     * 主要树种
     */
    private String zysz;

    /**
     * 不动产权首次登记证明单号
     */
    private String scdjzmdh;

    /**
     * 不动产登记证明号/预告登记证号
     */
    private String ygdjzh;

    /**
     * 不动产权证号/林权证号
     */
    private String lqzh;

    /**
     * 不动产登记证明号
     */
    private String bdcdjzmh;


}

