package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * 不动产字典类型表(GxYyZdType)表实体类BO
 *
 * @author makejava
 * @since 2023-05-31 16:38:57
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyZdType implements Serializable {
    private static final long serialVersionUID = -5344621254797093929L;
    private String id;

    /**
     * 代码
     */
    private String dm;

    /**
     * 名称
     */
    private String mc;

    /**
     * 类型(
     * SFCD:税费承担;BDCLX:不动产类型;DJLX:登记类型;
     * DKFS:贷款方式;DYFS:抵押方式;FKFS:付款方式;
     * FWJG:房屋结构;FWLX:房屋类型;FWTC:房屋套次;
     * FWYT:房屋用途;GYFS:共有方式;GZWLX:构筑物类型;
     * HJLX:户籍类型;HYZT:婚姻状态;JFFS:交付方式;MJDW:面积单位;
     * NEWS_TYPE:新闻类型;QLLX:权利类型;QLRLX:权利人类型;
     * SFCD:税费承担;SYQLX:使用权类型（内蒙古-克什克腾旗）;
     * TDYT:土地用途;ZJLX:证件类型;
     */
    private String zdType;

    /**
     * 是否删除（0:未删除，1：删除）
     */
    private Integer isDelete;

    /**
     * 描述
     */
    private String describe;

    private String sxh;

    /**
     * 父类型
     */
    private String fZdType;

    /**
     * 父类型代码
     */
    private String fDm;
}

