package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/12/5
 * @description
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyJtcy implements Serializable {

    private static final long serialVersionUID = -7957939419958004033L;

    private String id;
    /**
     * 申请id
     */
    private String sqid;

    /**
     * 家庭成员名称
     */
    private String jtcymc;

    /**
     * 家庭成员证件号
     */
    private String jtcyzjh;

    /**
     * 与买（卖）家关系
     */
    private String jtgx;

    /**
     * 脱敏字段家庭成员名称
     */
    private String jtcymcTm;

    /**
     * 脱敏字段家庭成员证件号
     */
    private String jtcyzjhTm;


    /**
     * 家庭成员婚姻状态(zd_type=HYZT)
     */
    private String jtcyhyzt;

    /**
     * 唯一申报号
     */
    private String wysbh;

    /**
     * 家庭成员房屋套次
     */
    private String jtcyfwtc;

    /**
     * 家庭成员联系电话
     */
    private String jtmc;

    /**
     * 是否有未成年子女
     */
    private String sfywcnzn;

    /**
     * 状态
     */
    private String status;
    /**
     * 个税申报方式（1：差额征收、2：全额征收）
     */
    private String gssbfs;
    /**
     * 契税满两年 （0：未满两年、1：满两年未满五年、2：满五年）
     */
    private String qsmln;
}
