package cn.gtmap.hlw.core.enums.dict.sign;

import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.hlw.core.enums.qlr.YqztEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2023/7/20
 * @description 云签签署状态枚举
 */
@Getter
@AllArgsConstructor
public enum SignQsztEnum {
    /**
     * 云签签署状态枚举
     */
    SIGN_QSZT_WQS(0, "未签署"),
    SIGN_QSZT_QSZ(1, "签署中"),
    SIGN_QSZT_QSWC(2, "签署完成"),
    SIGN_QSZT_QSSB(3, "签署失败"),
    SIGN_QSZT_JQ(4, "拒签"),
    SIGN_QSZT_CX(5, "撤销");

    @Getter
    private Integer dm;

    @Getter
    private String mc;


    public static String getMsg(Integer code) {
        for (SignQsztEnum qsztEnum : SignQsztEnum.values()) {
            if (qsztEnum.dm.equals(code)) {
                return qsztEnum.getMc();
            }
        }
        return null;
    }

    /**
     * 获取一窗云签状态
     *
     * @param qszt
     * @return
     */
    public static String getYcYqzt(Integer qszt) {
        Integer yqzt = YqztEnum.CJZT_SUCCESS.getCode();
        switch (qszt) {
            case 0:
                yqzt = YqztEnum.CJZT_SUCCESS.getCode();
                break;
            case 1:
                yqzt = YqztEnum.CJZT_QSZ.getCode();
                break;
            case 2:
                yqzt = YqztEnum.CJZT_YQS.getCode();
                break;
            case 3:
                yqzt = YqztEnum.CJZT_FAILURE.getCode();
                break;
            case 4:
                yqzt = YqztEnum.CJZT_JQ.getCode();
                break;
            case 5:
                yqzt = YqztEnum.CJZT_FAILURE.getCode();
                break;
            default:
                YqztEnum.CJZT_SUCCESS.getCode();
        }
        return CommonUtil.formatEmptyValue(yqzt);
    }
}
