package cn.gtmap.hlw.core.enums.dict;


import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author： admin
 * @Data: 2020/12/4
 * @Description: 贷款方式
 */
@Getter
@AllArgsConstructor
public enum LoanTypeEnum {

    /**
     * 商业贷款
     */
    SYDK("1", "商业贷款"),

    /**
     * 公积金贷款
     */
    GJJDK("2", "公积金贷款"),

    /**
     * 组合贷款
     */
    ZHDK("3", "组合贷款"),

    /**
     * 不贷款
     */
    BDK("4", "不贷款"),

    /**
     * 其他
     */
    QT("99", "其他");

    @Getter
    private String code;

    @Getter
    private String msg;

}
